﻿[//lasso
/*----------------------------------------------------------------------------

[weatherbug_getliveweather]
Returns live weather conditions for the given WeatherBug station.

Author: Jason Huck
Last Modified: May. 08, 2006
License: Artistic license <http://opensource.org/licenses/artistic-license.php>

Description:
Returns detailed, live current weather conditions via the WeatherBug API. 
Requires a valid WeatherBug API key. This tag also requires the [xml_tree] 
type.


Sample Usage:
var('full') = weatherbug_getliveweather(
	-key=$key,
	-zip=$zip,
	-station='XXXXX'
);

iterate($full->keys, local('i'));
	#i + ': ';
	
	protect;
		local('x') = @$full->find(#i);
		
		if(#x->isa('map'));
			#x->find('value') + ' ';
			#i == 'moon-phase' ? #x->find('moon-phase-img') | #x->find('units');
		else;
			#x;
		/if;
	/protect;
	
	'<br>\n';
/iterate;


Downloaded from tagSwap.net on Feb. 14, 2007.
Latest version available from <http://tagSwap.net/weatherbug_getliveweather>.

----------------------------------------------------------------------------*/
		

define_tag(
	'getliveweather',
	-namespace='weatherbug_',
	-required='key',
	-required='zip',
	-required='station',
	-priority='replace',
	-description='Returns live weather conditions for the given WeatherBug station.'
);
	local('url' = 'http://' + #key + '.api.wxbug.net/getLiveWeather.aspx');
	local('getparams') = array(
		'acode' = #key,
		'zipcode' = #zip,
		'StationID' = #station
	);
	
	local('response') = include_url(
		#url,
		-getparams=#getparams
	);
	
	local('xmldata') = xml_tree(#response);

	local('times') = array(
		'ob-date',
		'gust-time',
		'sunrise',
		'sunset'
	);
	
	local('out' = map);
	
	iterate(#xmldata->ob->children, local('i'));
		if(#i->name && #i->name != 'text');
			if(#times !>> #i->name);
				local('map' = map);
				#map->insert('value' = #i->contents);
				
				#i->attributes->size ? #map->insert(#i->attributes->first->first = decode_xml(#i->attributes->first->second));
										
				#out->insert(#i->name = #map);
			else;
				local(
					'yr' = #i->year->attribute('number'),
					'mo' = #i->month->attribute('number'),
					'dy' = #i->day->attribute('number'),
					'H' = #i->hour->attribute('hour-24'),
					'M' = #i->minute->attribute('number'),
					'S' = #i->second->attribute('number'),
				);

				local('datestring') = #yr + '-' + #mo + '-' + #dy + ' ' + #H + ':' + #M + ':' + #S;
				local('date') = date(#datestring, -format='%Y-%m-%d %H:%M:%S');
				
				#out->insert(#i->name = #date);
			/if;
		/if;
	/iterate;
		
	return(@#out);		
/define_tag;
]
